(function() {
  //Farmerswife  4/06/2013
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'models/event/EventModel', 'models/time/TimeModel', 'models/objects/ObjectModel', 'models/project/ProjectModel', 'collections/project/ProjectCollection', 'collections/objects/ObjectCollection', 'views/objectbrowser/ObjectFolderBrowserView', 'views/project/ProjectListView', "views/cfield/CustomFieldView", 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, EventModel, TimeModel, ObjectModel, ProjectModel, ProjectCollection, ObjectCollection, ObjectFolderBrowserView, ProjectListView, CustomFieldView) {
    var EditBookingView;
    return EditBookingView = class EditBookingView extends Backbone.View {
      initialize(usr, obj1, bs, eventsCol, event1, dateSelected) {
        var ref, ref1, ref2;
        this.usr = usr;
        this.obj = obj1;
        this.bs = bs;
        this.eventsCol = eventsCol;
        this.event = event1;
        this.dateSelected = dateSelected;
        this.bookingList = this.bs.get('BookingName');
        if (!this.bookingList) {
          this.bookingList = (ref = this.bs.get(0)) != null ? ref.BookingName : void 0;
        }
        this.statusBookingList = this.bs.get('BookingStatus');
        if (!this.statusBookingList) {
          this.statusBookingList = (ref1 = this.bs.get(0)) != null ? ref1.BookingStatus : void 0;
        }
        this.checkpointBookingList = this.bs.get('BookingStage');
        if (!this.checkpointBookingList) {
          this.checkpointBookingList = (ref2 = this.bs.get(0)) != null ? ref2.BookingStage : void 0;
        }
        this.projectCol = new ProjectCollection();
        this.project = new ProjectModel();
        this.project.get_project_booking(this.usr, this.event.get('Booking').parentID);
        this.project.on('project_booking_updated', _.bind(this.print_project_binders, this, this.project));
        this.tm = new TimeModel();
        this.comingFromView = null;
        return this.objectCol = new ObjectCollection();
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-btn-done-name': 'btnDoneNameClicked',
          //'tap #id-btn-done-booking-status': 'btnDoneStatusClicked'

          //TABS
          'tap .btn-submenu-addbooking': 'subMenuAddBookingClicked',
          //SHOWING FORM COMPONENTS
          'tap .edit-request-name': 'btnRequestNameClicked',
          'tap .edit-booking-status': 'btnBookingStatusClicked',
          //'tap .edit-request-date' : 'btnRequestDateClicked'
          'tap .edit-request-note': 'btnRequestNoteClicked',
          'tap .edit-involved-extra-info': 'btnInvolvedExtraInfoClicked',
          'tap .edit-involved-note': 'btnInvolvedNoteClicked',
          'tap .checkpoint-name': 'btnBookingCheckpointClicked',
          //SETTING DATE REQUEST
          'tap #btn-input-booking-dayIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-booking-dayOut': 'btnRequestDateTimeClicked',
          'tap #btn-input-booking-timeIn': 'btnRequestDateTimeClicked',
          'tap #btn-input-booking-timeOut': 'btnRequestDateTimeClicked',
          'change .time': 'btnBookingDateTimeChanged',
          'change #id-slider-allDay': 'btnAllDayChanged',
          //SETTING REQUEST NAME
          'change input[name=radio-request]': 'btnRadioNameChanged',
          //SETTING  STATUS
          'change input[name=radio-booking-status]': 'btnRadioStatusChanged',
          //SETTING  CHECKPOINT
          'change input[name=radio-booking-checkpoint]': 'btnRadioCheckpointChanged',
          //SETTING REQUEST NOTE
          'tap #id-btn-done-note': 'btnDoneNoteClicked',
          //SETTING PROJECT BINDERS
          'change input[name=radio-project-binder]': 'btnRadioBinderChanged',
          //SETTING ACTIVITY INVOLVED
          'change input[name=radio-booking-involved-activity]': 'btnRadioActivityChanged',
          'tap .edit-involved-activity': 'btnBookingInvolvedActivityClicked',
          //SETTING CLASS INVOLVED
          'change input[name=radio-booking-involved-class]': 'btnRadioClassChanged',
          'tap .edit-involved-class': 'btnBookingInvolvedClassClicked',
          //ADD INVOLVED
          'tap #id-btn-addInvolved': 'btnAddBookingInvolvedClicked',
          //'tap .spanTimeEvent' : 'btnTimeInvolvedClicked'
          'tap .btn-timeIN-involved': 'btnTimeInvolvedClicked',
          'tap .btn-timeOUT-involved': 'btnTimeInvolvedClicked',
          'change .input-involved-timein': 'inputTimeInvolvedChanged',
          'change .input-involved-timeout': 'inputTimeInvolvedChanged',
          'change .slider-involved-allday': 'sliderAllDayInvolvedChanged',
          'tap .btn-delete-involved': 'btnDeleteInvolvecClicked',
          'tap .btn-done-note-involved': 'btnDoneNoteInvolvedClicked',
          //SET PROJECT
          'tap .edit-booking-project': 'btnAddBookingProjectClicked',
          //SET BINDER
          'tap .edit-booking-binder': 'btnBookingBinderClicked',
          //SAVING TASK
          'tap #id-btn-save-booking': 'btnSaveBookingClicked',
          'tap #id-btn-delete-booking': 'btnDeleteBookingClicked',
          'pageshow': 'pageShown',
          //POPUP CLOSE
          'tap .popUpDismiss': 'btnPopupClose'
        };
      }

      render() {
        var template;
        template = Handlebars.templates['EditBookingView'];
        this.$el.html(template({
          usr: this.usr.toJSON(),
          booking: this.event.toJSON().Booking,
          bookingList: this.bookingList,
          statusBookingList: this.statusBookingList,
          checkpointBookingList: this.checkpointBookingList,
          allDay: this.event.__is_all_day(),
          mainDate: this.dateSelected.format("dddd Do MMMM"),
          year: this.dateSelected.format('YYYY'),
          humanDate: this.dateSelected.calendar(),
          defaultTimeIn: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')),
          defaultTimeOut: this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime')),
          daySelected: this.dateSelected.format('DD-MM-YYYY'),
          userMustSelectRequestType: this.usr.__must_select_request_type(),
          dayIn: this.event.__get_first_and_last_day(this.dateSelected).dayIn,
          dayOut: this.event.__get_first_and_last_day(this.dateSelected).dayOut
        }));
        console.log(this.usr.__default_time_breaks());
        console.log(this.usr.__must_select_request_type());
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuAddBookingClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        if (!btn.hasClass('ui-disabled')) {
          id = btn.attr('data-target');
          this.$el.find('.subEditBookingView').hide();
          return $(id).show();
        }
      }

      pageShown() {
        var involved;
        if (!this.comingFromView) {
          involved = this.event.get('Booking').Involved;
          if (!_.isArray(this.event.get('Booking').Involved)) {
            involved = [this.event.get('Booking').Involved];
          }
          _.each(involved, (inv) => {
            return this.print_li_involved(inv);
          });
          this.__set_cfields_tab();
          //SELECT TAB
          if (this.$el.find('#id-divAddBookingInvolved').is(':visible')) {
            this.$el.find('#id-submenu-addbooking-involved').addClass('ui-btn-active');
            return this.$el.find('#id-submenu-addbooking-details').removeClass('ui-btn-active');
          } else {
            this.$el.find('#id-submenu-addbooking-details').addClass('ui-btn-active');
            return this.$el.find('#id-submenu-addbooking-involved').removeClass('ui-btn-active');
          }
        } else {
          return this.comingFromView = null;
        }
      }

      //SHOWING FORMS COMPONENTS
      btnRequestNoteClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.$el.find('.div-request-note-form').toggle();
      }

      btnRequestNameClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_name_form();
      }

      btnBookingStatusClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_status_form();
      }

      btnBookingCheckpointClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_stage_form();
      }

      btnBookingBinderClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return this.__go_to_projectbinder_form();
      }

      btnInvolvedNoteClicked(event) {
        var ref, ref1;
        event.stopPropagation();
        event.preventDefault();
        //FIRST HANDLE HELPER 'Tap to edit involved'
        if (((ref = this.$(event.currentTarget).find('.fwi-edit')) != null ? ref.length : void 0) > 0) {
          this.$(event.currentTarget).find('.fwi-edit').addClass('fwi-cross-cancel').removeClass('fwi-edit');
        } else {
          this.$(event.currentTarget).find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
        //SHOW/HIDE   NOTE FORM
        this.$(event.currentTarget).closest('li').find('.note-info').toggle();
        //HIDE EXTRA INFO FORM
        this.$(event.currentTarget).parent().find('.extra-info').hide();
        if (((ref1 = this.$(event.currentTarget).closest('li').find('.edit-involved-extra-info').find('.fwi-cross-cancel')) != null ? ref1.length : void 0) > 0) {
          return this.$(event.currentTarget).closest('li').find('.edit-involved-extra-info').find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
      }

      btnInvolvedExtraInfoClicked(event) {
        var ref;
        event.stopPropagation();
        event.preventDefault();
        // EXTRA INFO ICON
        if (((ref = this.$(event.currentTarget).find('.fwi-edit')) != null ? ref.length : void 0) > 0) {
          this.$(event.currentTarget).find('.fwi-edit').addClass('fwi-cross-cancel').removeClass('fwi-edit');
        } else {
          this.$(event.currentTarget).find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        }
        //SHOW/HIDE FORM  Extra INFO
        this.$(event.currentTarget).parent().find('.extra-info').toggle();
        if (this.$(event.currentTarget).parent().find('.extra-info').is(':visible')) {
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').hide();
          //NOTE ICON
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').find('.fwi-cross-cancel').addClass('fwi-edit').removeClass('fwi-cross-cancel');
        } else {
          this.$(event.currentTarget).closest('li').find('.edit-involved-note').show();
        }
        //HIDE FORM NOTE
        return this.$(event.currentTarget).closest('li').find('.note-info').hide();
      }

      btnBookingInvolvedActivityClicked(event) {
        var cur;
        event.stopPropagation();
        event.preventDefault();
        cur = $(event.currentTarget);
        return this.__go_to_involved_activity_form(cur.parents('li'));
      }

      btnBookingInvolvedClassClicked(event) {
        var cur;
        event.stopPropagation();
        event.preventDefault();
        cur = $(event.currentTarget);
        return this.__go_to_involved_class_form(cur.parents('li'));
      }

      //SETTING Booking DATES
      btnAllDayChanged(event) {
        var btn, status, time, timeIn, timeOut;
        btn = $(event.currentTarget);
        status = btn.val();
        if (status === 'on') { //SETTING ALL DAY TO EVERYTHING
          time = '00:00';
          this.$el.find('#id-input-booking-timeIn').val(time);
          this.$el.find('#id-input-booking-timeOut').val(time);
          this.$el.find('#id-span-booking-timeIn').text(time);
          this.$el.find('#id-span-booking-timeOut').text(time);
          this.$el.find('#btn-input-booking-timeIn').find('.ui-btn-text').html(time);
          this.$el.find('#btn-input-booking-timeOut').find('.ui-btn-text').html(time);
          this.$el.find('#id-p-allDay').show();
          this.$el.find('#id-p-times').hide();
          //HIDE TIMEIN /TIMEOUT
          this.$el.find('.timeButtons').hide();
          //@$el.find('#btn-input-booking-timeIn').hide()
          //@$el.find('#btn-input-booking-timeOut').hide()
          return this.__set_involved_times(true, time, time);
        } else {
          timeIn = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime'));
          timeOut = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime'));
          this.$el.find('#id-input-booking-timeIn').val(timeIn);
          this.$el.find('#id-input-booking-timeOut').val(timeOut);
          this.$el.find('#id-span-booking-timeIn').text(timeIn);
          this.$el.find('#id-span-booking-timeOut').text(timeOut);
          this.$el.find('#btn-input-booking-timeIn').find('.ui-btn-text').html(timeIn);
          this.$el.find('#btn-input-booking-timeOut').find('.ui-btn-text').html(timeOut);
          this.$el.find('#id-p-allDay').hide();
          this.$el.find('#id-p-times').show();
          //SHOW TIMEIN /TIMEOUT
          this.$el.find('.timeButtons').show();
          return this.__set_involved_times(false, timeIn, timeOut);
        }
      }

      btnRequestDateTimeClicked(event) {
        var curBtn, input, options, timeOptions, type;
        event.stopPropagation();
        event.preventDefault();
        curBtn = $(event.currentTarget);
        input = curBtn.attr('data-target');
        type = curBtn.attr('data-type');
        options = {
          theme: 'iOS',
          display: 'bottom',
          dateFormat: 'dd-mm-yy',
          dateOrder: 'ddmmyy',
          onChange: this.__validate,
          maxDate: window.MAXDATE
        };
        timeOptions = {
          theme: 'iOS',
          display: 'bottom',
          onChange: this.__validate
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        switch (type) {
          case 'DI':
            $(input).mobiscroll().date(options);
            break;
          case 'TI':
            $(input).mobiscroll().time(timeOptions);
            break;
          case 'DO':
            $(input).mobiscroll().date(options);
            break;
          case 'TO':
            $(input).mobiscroll().time(timeOptions);
        }
        return $(input).mobiscroll('show');
      }

      btnBookingDateTimeChanged(event) {
        var btnTarget, dateIn, dateOut, formatStr, formatTime, gap, input, legend, newTo, popUp, popUpHtml, str, ti, to, type;
        //TODO SET TIME PICKER WITH BIGGER DATE INI > OUT    NOT CONSIDERING TIME&DAy ONLY DAY
        input = $(event.currentTarget);
        btnTarget = input.attr('data-target');
        type = $(btnTarget).attr('data-type');
        formatTime = 'h:mm A';
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          formatTime = 'h:mm';
        }
        switch (type) {
          case 'TI':
            str = input.val();
            //# CHECK IF ITS IN SERVER LIMITS FOR STARTING TIME OR NOT
            gap = this.tm.get_float_from_time_string(this.usr.get('dayStartsAt'), str);
            if (gap < 0) {
              input.val(this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime')));
              popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>Error With Your Initial Time</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>You are adding a booking before your day starts, please check your Initial Time<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a>
</div>
</div>`;
              this.$el.append(popUpHtml);
              popUp = this.$el.find('#popupAlert');
              popUp.popup();
              popUp.trigger('create');
              popUp.popup('open');
              return;
            }
            formatStr = 'H:mm';
            if (_.indexOf(str, 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(input.val(), formatStr);
            to = Moment(this.$el.find('#id-input-booking-timeOut').val(), formatStr);
            newTo = to.format(formatStr);
            if (ti > to) {
              ti.add('m', 15);
              newTo = ti.format(formatStr);
              this.$el.find('#id-input-booking-timeOut').val(newTo); //SET TIME OUT INPUT
              this.$el.find('#id-span-booking-timeOut').text(newTo); //SET BLUE DIV
              this.$el.find('#btn-input-booking-timeOut').find('.ui-btn-text').html(newTo); //SET TIME OUT BUTTON
            }
            
            // SET TIME ON BLUE DIV
            this.$el.find('#id-span-booking-timeIn').text(str);
            if (this.$el.find('#id-slider-allDay').val() === 'on') {
              this.$el.find('#id-slider-allDay').val('off');
              this.$el.find('#id-slider-allDay').trigger('change');
            }
            /* SET ALL INVOLVED TIMES TO THIS ONE */
            this.__set_involved_times(false, str, newTo);
            break;
          case 'DI':
            str = input.val();
            dateIn = Moment(input.val(), 'DD-MM-YYYY');
            dateOut = Moment(this.$el.find('#id-input-booking-dayOut').val(), 'DD-MM-YYYY');
            if (dateIn > dateOut) {
              this.$el.find('#id-input-booking-dayOut').val(str);
              this.$el.find('#id-input-booking-dayOut').trigger('change');
            }
            // SET TIME ON BLUE DIV
            this.$el.find('.main-date strong').text(dateIn.format("dddd Do MMMM"));
            this.$el.find('.year').text(dateIn.format("YYYY"));
            this.$el.find('.human-date').text(dateIn.calendar());
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            //SET TIME LEGEND IF NEEDED
            if (dateOut.diff(dateIn, 'days') > 0) {
              this.$el.find('#id-p-request-legend').text(legend);
            } else {
              this.$el.find('#id-p-request-legend').text('');
            }
            break;
          case 'TO':
            str = input.val();
            // SET TIME ON BLUE DIV
            this.$el.find('#id-span-booking-timeOut').text(str);
            if (this.$el.find('#id-slider-allDay').val() === 'on') {
              this.$el.find('#id-slider-allDay').val('off');
              this.$el.find('#id-slider-allDay').trigger('change');
            }
            /* SET ALL INVOLVED TIMES TO THIS ONE */
            this.__set_involved_times(false, this.$el.find('#id-input-booking-timeIn').val(), str);
            break;
          case 'DO':
            str = input.val();
            dateIn = Moment(this.$el.find('#id-input-booking-dayIn').val(), 'DD-MM-YYYY');
            dateOut = Moment(input.val(), 'DD-MM-YYYY');
            legend = dateIn.format('dddd Do MMMM') + ' - ' + dateOut.format('dddd Do MMMM') + ' (1/' + (dateOut.diff(dateIn, 'days') + 1) + ')';
            // SET TIME LEGEND
            if (dateOut.diff(dateIn, 'days') > 0) {
              this.$el.find('#id-p-request-legend').text(legend);
            } else {
              this.$el.find('#id-p-request-legend').text('');
            }
        }
        return $(btnTarget).find('.ui-btn-text').html(str);
      }

      __validate(date, inst) {
        var dateIn, dateOut, instOut, timeInstOut;
        //dayIn  = $('#id-input-booking-dayIn').mobiscroll('getInst')
        instOut = $('#id-input-booking-dayOut').mobiscroll('getInst');
        timeInstOut = $('#id-input-booking-timeOut').mobiscroll('getInst');
        if (instOut != null ? instOut.isVisible() : void 0) {
          if (_.indexOf($('#id-input-booking-timeOut').val(), 'M') === -1) {
            dateOut = Moment(date + ' ' + $('#id-input-booking-timeOut').val(), 'DD-MM-YYYY h:mm');
            dateIn = Moment($('#id-input-booking-dayIn').val() + ' ' + $('#id-input-booking-timeIn').val(), 'DD-MM-YYYY h:mm');
          } else {
            dateOut = Moment(date + ' ' + $('#id-input-booking-timeOut').val(), 'DD-MM-YYYY h:mm A');
            dateIn = Moment($('#id-input-booking-dayIn').val() + ' ' + $('#id-input-booking-timeIn').val(), 'DD-MM-YYYY h:mm A');
          }
          if (dateIn > dateOut) {
            $('.dwv').html('<strong>Ini Day > End Day</strong>');
            $('.dwbw.dwb-s').hide();
          } else {
            $('.dwbw.dwb-s').show();
            return;
          }
        }
        if (timeInstOut != null ? timeInstOut.isVisible() : void 0) {
          if (_.indexOf(timeInstOut.val, 'M') === -1) {
            dateOut = Moment(date, 'H:mm');
            dateIn = Moment($('#id-input-booking-timeIn').val(), 'H:mm');
          } else {
            dateOut = Moment(date, 'h:mm A');
            dateIn = Moment($('#id-input-booking-timeIn').val(), 'h:mm A');
          }
          if (dateIn > dateOut) {
            $('.dwv').html('<strong>Ini Date > End Date</strong>');
            return $('.dwbw.dwb-s').hide();
          } else {
            $('.dwbw.dwb-s').show();
          }
        }
      }

      //SETTING TASK NOTE
      btnDoneNoteClicked(event) {
        var reqNote;
        event.stopPropagation();
        event.preventDefault();
        reqNote = this.$el.find('#id-input-booking-note').val();
        this.$el.find('p.edit-request-note').text(reqNote);
        return this.$el.find('.div-request-note-form').hide();
      }

      //SETTING TASK NAME
      btnRadioNameChanged(event) {
        var radio, reqName;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        reqName = radio.val();
        $('p.edit-request-name').text(reqName);
        this.$el.find('#id-input-booking-name').val(reqName);
        this.$el.find('#id-input-booking-name').attr('data-nameID', radio.attr('data-nameID'));
        $('p.edit-request-name').attr('data-nameID', radio.attr('data-nameID'));
        return this.__go_to_request_form(reqName);
      }

      btnDoneNameClicked(event) {
        var input, reqName;
        event.stopPropagation();
        event.preventDefault();
        input = this.$el.find('#id-input-booking-name');
        reqName = input.val();
        $('p.edit-request-name').text(reqName);
        return this.__go_to_request_form(reqName);
      }

      //SETTING Booking CHECKPOINT
      btnRadioCheckpointChanged(event) {
        var curClass, newClass, radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        this.$el.find('span.checkpoint-name').text(st);
        this.$el.find('span.checkpoint-name').attr('data-stageValue', radio.attr('data-stageValue'));
        curClass = this.$el.find('#id-p-checkpoint .fwi-checkpoint').attr('class');
        switch (st) {
          case 'Cancelled':
            newClass = 'fwi-checkpoint checkpoint-cancel';
            break;
          case 'Completed':
            newClass = 'fwi-checkpoint checkpoint-complete';
            break;
          case 'Ignore':
            newClass = 'fwi-checkpoint checkpoint-ignore';
            break;
          case 'In Progress':
            newClass = 'fwi-checkpoint checkpoint-progress';
            break;
          case 'Pending':
            newClass = 'fwi-checkpoint checkpoint-pending';
        }
        this.$el.find('#id-p-checkpoint .fwi-checkpoint').removeClass(curClass).addClass(newClass);
        this.$el.find('#id-input-booking-checkpoint').val(st);
        return this.__go_to_request_form();
      }

      //SETTING TASK STATUS
      btnRadioStatusChanged(event) {
        var radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        $('p.edit-booking-status').text(st);
        this.$el.find('#id-input-booking-status').val(st);
        return this.__go_to_request_form('status');
      }

      //SETTING PROJECT BINDER
      btnRadioBinderChanged(event) {
        var radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        if (radio.attr('data-projectBinderFullPathName') !== radio.val()) {
          st = radio.attr('data-projectBinderFullPathName');
        } else {
          st = radio.val();
        }
        this.$el.find('#id-p-booking-binder').text(st);
        this.$el.find('#id-p-booking-binder').attr('data-binderid', radio.attr('data-binderid'));
        this.$el.find('#id-p-booking-binder').attr('data-parentbinderid', radio.attr('data-parentbinderid'));
        //@$el.find('#id-input-booking-status').val(st)
        return this.__go_to_request_form('binder');
      }

      btnRadioActivityChanged(event) {
        var li, pos, radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        //GETTING LI OF INVOLVED => IF IT DOES NOT HAVE data-li-pos attribute means it the last one added
        pos = this.$el.find('#id-activity-involved-form').attr('data-li-pos');
        if (!pos) {
          pos = this.$el.find('.liBookingInvolved').length - 1;
        }
        li = $(this.$el.find('.liBookingInvolved')[pos]);
        li.find('.edit-involved-activity span.text').text(radio.val());
        li.attr('data-activityid', radio.attr('data-activityid'));
        li.find('.edit-involved-activity').attr('data-activityid', radio.attr('data-activityid'));
        li.find('.edit-involved-activity').attr('data-activityname', radio.val());
        //@$el.find('#id-input-booking-status').val(st)
        return this.__go_to_involved_list();
      }

      btnRadioClassChanged(event) {
        var li, pos, radio, st;
        event.stopPropagation();
        event.preventDefault();
        radio = $(event.currentTarget);
        st = radio.val();
        //GETTING LI OF INVOLVED => IF IT DOES NOT HAVE data-li-pos attribute means it the last one added
        pos = this.$el.find('#id-class-involved-form').attr('data-li-pos');
        if (!pos) {
          pos = this.$el.find('.liBookingInvolved').length - 1;
        }
        li = $(this.$el.find('.liBookingInvolved')[pos]);
        li.find('.edit-involved-class span.text').text(radio.val());
        li.attr('data-objectclassid', radio.attr('data-objectclassid'));
        li.find('.edit-involved-class').attr('data-objectclassid', radio.attr('data-objectclassid'));
        li.find('.edit-involved-class').attr('data-objectclassname', radio.val());
        //@$el.find('#id-input-booking-status').val(st)
        return this.__go_to_involved_list();
      }

      //PROJECT ADDED PRINTING DETAILS
      print_project_added(proj) {
        var client, contact, name;
        //console.log proj.toJSON()
        name = proj.get('name');
        client = proj.get('contactCompanyName');
        contact = proj.get('contactName');
        proj.on('project_booking_updated', _.bind(this.print_project_binders, this, proj));
        //proj.on('project_booking_updated',@print_project_binders,@)
        this.$el.find('#id-p-booking-project').text(name);
        this.$el.find('#id-p-booking-project').attr('data-projectid', proj.get('id'));
        this.$el.find('#id-p-booking-project').attr('data-projectnumber', proj.get('number'));
        if (contact) {
          this.$el.find('#id-p-booking-contact').text(contact);
        }
        if (client) {
          this.$el.find('#id-p-booking-client').text(client);
        }
        return proj.get_project_booking(this.usr, proj.get('id'));
      }

      print_project_binders(proj) {
        var bind, binders, el, i, len, name, noneEl, parentBind, parentBinderID;
        //console.log proj.toJSON()
        binders = proj != null ? proj.get('bookingProject').Binder : void 0;
        this.$el.find('#id-projectbinder-form').empty();
        noneEl = "<input type=\"radio\" name=\"radio-project-binder\" id=\"radio-choice-none\" value=\"None\" data-binderID=\"\" />";
        noneEl += "<label for=\"radio-choice-none\">None</label>";
        this.$el.find('#id-projectbinder-form').append(noneEl);
        if (binders && !_.isArray(binders)) {
          binders = [binders];
        }
        if ((binders != null ? binders.length : void 0) > 0) {
          for (i = 0, len = binders.length; i < len; i++) {
            bind = binders[i];
            //CHECKING IF IT HAS A PARENT BINDER
            if (bind.parentBinderID) {
              parentBind = _.findWhere(binders, {
                binderID: bind.parentBinderID
              });
              name = parentBind.name + ' / ' + bind.name;
              parentBinderID = bind.parentBinderID;
            } else {
              name = bind.name;
              parentBinderID = '';
            }
            el = `<input type=\"radio\" name=\"radio-project-binder\" id=\"radio-choice-${bind.binderID}\" value=\"${bind.name}\" data-binderID=\"${bind.binderID}\" data-parentbinderID=\"${parentBinderID}\" data-projectBinderFullPathName=\"${name}\"/>`;
            el += `<label for=\"radio-choice-${bind.binderID}\">${name}</label>`;
            this.$el.find('#id-projectbinder-form').append(el);
          }
        }
        return this.$el.find('#id-projectbinder-form').trigger('create');
      }

      //@__go_to_projectbinder_form()
      print_activity_list(view, activities, goToList) {
        var noEl, ulActivities;
        //console.log activities
        ulActivities = view.$el.find('#id-activity-involved-form');
        ulActivities.empty();
        noEl = "<input type=\"radio\" name=\"radio-booking-involved-activity\" id=\"radio-choice-none\" value=\"None\" data-activityID=\"\" />";
        noEl += "<label for=\"radio-choice-none\">None</label>";
        ulActivities.append(noEl);
        if ((activities != null ? activities.length : void 0) > 0) {
          _.each(activities, (act) => {
            var el;
            el = `<input type=\"radio\" name=\"radio-booking-involved-activity\" id=\"radio-choice-${act.activityID}\" value=\"${act.name}\" data-activityID=\"${act.activityID}\" />`;
            el += `<label for=\"radio-choice-${act.activityID}\">${act.name}</label>`;
            return ulActivities.append(el);
          });
          if (goToList) {
            view.__go_to_involved_activity_form();
          }
        }
        ulActivities.listview();
        return ulActivities.listview('refresh');
      }

      print_class_list(view, classes, goToList) {
        var noEl, ulClasses;
        //console.log activities
        ulClasses = view.$el.find('#id-class-involved-form');
        ulClasses.empty();
        noEl = "<input type=\"radio\" name=\"radio-booking-involved-class\" id=\"radio-choice-none\" value=\"None\" data-objectClassID=\"\" data-objectClassName=\"\"/>";
        noEl += "<label for=\"radio-choice-none\">None</label>";
        ulClasses.append(noEl);
        if ((classes != null ? classes.length : void 0) > 0) {
          _.each(classes, (cls) => {
            var el;
            el = `<input type=\"radio\" name=\"radio-booking-involved-class\" id=\"radio-choice-${cls.objectID}\" value=\"${cls.name}\" data-objectClassID=\"${cls.objectID}\" data-objectClassName=\"${cls.name}\" />`;
            el += `<label for=\"radio-choice-${cls.objectID}\">${cls.name}</label>`;
            return ulClasses.append(el);
          });
          if (goToList) {
            view.__go_to_involved_class_form();
          }
        }
        ulClasses.listview();
        return ulClasses.listview('refresh');
      }

      //INVOLVED TAB
      print_li_involved(aux) {
        var activityID, activityName, allDay, allDayHTML, bookingLineID, bookingTypeID, btnTimeInText, btnTimeOutText, dataTimeIn, dataTimeOut, displayTimeButtons, icon, id, li, name, note, obj, objClassID, objClassName, ref, ref1, ref2, spanHTML, timeIn, timeOut, type, ul;
        if (!(aux instanceof ObjectModel)) {
          obj = new ObjectModel(aux);
        } else {
          obj = aux;
        }
        name = obj.get('name');
        if (!name) {
          name = obj.get('objectName');
        }
        id = obj.get('objectID');
        type = obj.get('objectType');
        objClassID = obj.get('objectClassID');
        objClassName = obj.get('objectClassName');
        activityID = obj.get('activityID');
        activityName = obj.get('activityName');
        bookingLineID = obj.get('bookingLineID');
        bookingTypeID = obj.get('bookingTypeID') || "";
        icon = obj.__get_object_icon();
        timeIn = (ref = obj.get('timeIn')) != null ? ref : this.event.get('timeIn');
        timeOut = (ref1 = obj.get('timeOut')) != null ? ref1 : this.event.get('timeOut');
        note = (ref2 = obj.get('note')) != null ? ref2 : "Tap to add a note";
        //      activities = obj.get_object_activity(id)
        //      @print_activity_list(@,activities,false)
        //      classes = obj.get_object_class(id)
        //      @print_class_list(@,classes,false)
        if (timeIn === 0 && timeOut === 24) {
          allDay = true;
          allDayHTML = "selected=''";
          displayTimeButtons = 'style="display:none;"';
          dataTimeIn = "00:00";
          dataTimeOut = "00:00";
          btnTimeInText = "Time In";
          btnTimeOutText = "Time Out";
          spanHTML = 'All Day';
        } else {
          allDay = false;
          allDayHTML = '';
          displayTimeButtons = '';
          dataTimeIn = Handlebars.helpers.timeFloatToString(this.usr.get('dayStartsAt'), this.usr.get('usesAMPM'), timeIn);
          dataTimeOut = Handlebars.helpers.timeFloatToString(this.usr.get('dayStartsAt'), this.usr.get('usesAMPM'), timeOut);
          btnTimeInText = "Time In: " + dataTimeIn;
          btnTimeOutText = "Time Out: " + dataTimeOut;
          spanHTML = `<span>${dataTimeIn}</span> / <span>${dataTimeOut}</span>`;
        }
        li = `<li class=\"liBookingInvolved\" data-objectID=\"${id}\" data-objectType=\"${type}\" data-objectClassID=\"${objClassID}\" data-bookingLineID=\"${bookingLineID}\" data-timeIn=\"${dataTimeIn}\" data-timeOut=\"${dataTimeOut}\" data-activityID=\"${activityID}\" data-bookingTypeID=\"${bookingTypeID}\" data-involved-note=\"${note}\">`;
        li += `<div class='header edit-involved-extra-info'><span class='spanTimeEventInvolved' id=\"id-spanTimeEvent-${id}\">${spanHTML}</span><span class=\"name ${icon}\" > ${name} </span><span class='fwi-edit'/> </div>`;
        li += ` <div class='subheader-activity edit-involved-activity'><span class='fwi-edit'/><span class='label'>Activity</span><span class='text'> ${activityName}</span> </div>`;
        li += ` <div class='subheader-class edit-involved-class'><span class='fwi-edit'/><span class='label'>Class</span><span class='text'> ${objClassName}</span></div>`;
        li += ` <div class='subheader edit-involved-note'><span class='fwi-edit'/><span class='text'> ${note} </span> </div>`;
        li += '<div class="note-info" style="display:none;"><textarea placeholder="Involved Note" ></textarea><span class="btn btn-done-note-involved"> Done Editing Note</span></div>';
        li += '<div class="extra-info" style="display: none;">';
        li += "<div class='div-wrap-timecontrol' data-role='fieldset'>";
        //      li += '<h4>Set Time for Involved</h4>'
        li += `<label for='id-slider-allDay'>All Day </label> <select name=\"allDaySlider-${id}\" id=\"id-slider-allDay-${id}\" class='slider-involved-allday' data-id=\"${id}\" data-role='slider'> <option value='off' ${allDayHTML}>No</option> <option value='on'  ${allDayHTML}>Yes</option> </select>`;
        li += `<div class=\"wrapper-btn-time wrapper-btn-time-${id}\" ${displayTimeButtons}>`;
        li += `<span class=\"btn btn-timeIN-involved\" data-target=\"input-involved-timeIN-${id}\" id=\"id-btn-timeIN-${id}\" data-type='TI'> ${btnTimeInText} </span>`;
        li += `<span class=\"btn btn-timeOUT-involved\" data-target=\"input-involved-timeOUT-${id}\" id=\"id-btn-timeOUT-${id}\" data-type='TO'> ${btnTimeOutText} </span>`;
        li += '</div>';
        li += '<div class="div-wrap"><span class="btn btn-delete-involved"> Delete Involved</span></div>';
        li += `<input type='hidden' class='input-involved-timein' id=\"input-involved-timeIN-${id}\" data-id=\"${id}\" data-type='TI' value=\"${dataTimeIn}\"/><input type='hidden' class='input-involved-timeout' data-type='TO' id=\"input-involved-timeOUT-${id}\" data-id=\"${id}\" value=\"${dataTimeOut}\"/>`;
        li += '</div></li>';
        ul = this.$el.find('#id-ul-booking-involved');
        ul.append(li);
        this.$el.find('.extra-info').trigger('create');
        this.$el.find('.note-info').trigger('create');
        ul.listview();
        return ul.listview('refresh');
      }

      btnAddBookingProjectClicked(event) {
        var nextView;
        event.stopPropagation();
        event.preventDefault();
        if (!ProjectListView) {
          ProjectListView = require('views/project/ProjectListView');
        }
        this.projectCol.get_projects(this.usr);
        nextView = new ProjectListView(this.usr, this.projectCol, 'AddBooking');
        this.comingFromView = 'ProjectListView';
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      addedBookingProject(view, prjMdl) {
        view.print_project_added(prjMdl);
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnAddBookingInvolvedClicked(event) {
        var alreadyAddedViewIndex, found, i, index, len, nextView, ref, view;
        event.stopPropagation();
        event.preventDefault();
        if (!ObjectFolderBrowserView) {
          ObjectFolderBrowserView = require('views/objectbrowser/ObjectFolderBrowserView');
        }
        nextView = new ObjectFolderBrowserView(this.usr, 'BookingInvolved');
        alreadyAddedViewIndex = -1;
        index = 0;
        found = false;
        ref = $.mobile.jqmNavigator.getViews();
        for (i = 0, len = ref.length; i < len; i++) {
          view = ref[i];
          if (view instanceof ObjectFolderBrowserView) {
            alreadyAddedViewIndex = index;
            break;
          }
          index++;
        }
        if (alreadyAddedViewIndex > -1) {
          $.mobile.jqmNavigator.getViews().splice(alreadyAddedViewIndex, 1);
          $('#id-ObjectFolderBrowserView').remove();
        }
        this.comingFromView = 'ObjectFolderBrowserView';
        return $.mobile.jqmNavigator.pushView(nextView, {
          transition: 'none'
        });
      }

      addedBookingInvolved(view, objMdl) {
        var activities, classes;
        view.print_li_involved(objMdl);
        activities = objMdl.get_object_activity(objMdl.get('objectID'));
        classes = objMdl.get_object_class(objMdl.get('objectID'));
        view.print_activity_list(view, activities, true);
        view.print_class_list(view, classes, true);
        //COMING BACK TO TASK VIEW FROM OBJECT BRWOSER
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnTimeInvolvedClicked(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var cur, input, inputObj, timeOptions, type;
        event.stopPropagation();
        event.preventDefault();
        cur = $(event.currentTarget);
        input = '#' + cur.attr('data-target');
        type = cur.attr('data-type');
        inputObj = cur.parentsUntil('li').find(input);
        //console.log input

        //options = { theme: 'Android', display: 'bottom', dateFormat:'dd-mm-yy', dateOrder:'ddmmyy'}
        timeOptions = {
          theme: 'Android',
          display: 'bottom'
        };
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          timeOptions['timeFormat'] = 'H:ii';
          timeOptions['timeWheels'] = 'Hii';
        } else {
          timeOptions['timeFormat'] = 'h:ii A';
          timeOptions['timeWheels'] = 'hii A';
        }
        switch (type) {
          case 'TI':
            inputObj.mobiscroll().time(timeOptions);
            break;
          case 'TO':
            inputObj.mobiscroll().time(timeOptions);
        }
        return inputObj.mobiscroll('show');
      }

      sliderAllDayInvolvedChanged(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var btnTimeIn, btnTimeOut, idInvolved, inputTimeIn, inputTimeOut, li, sel, spanTimeEvent, status, time, timeIn, timeOut, wrapperTimeBtn;
        event.stopPropagation();
        event.preventDefault();
        sel = $(event.currentTarget);
        status = sel.val();
        idInvolved = sel.attr('data-id');
        li = sel.closest('li');
        inputTimeIn = sel.siblings(`#input-involved-timeIN-${idInvolved}`);
        inputTimeOut = sel.siblings(`#input-involved-timeOUT-${idInvolved}`);
        btnTimeIn = sel.siblings().find(`#id-btn-timeIN-${idInvolved}`);
        btnTimeOut = sel.siblings().find(`#id-btn-timeOUT-${idInvolved}`);
        spanTimeEvent = li.find(`#id-spanTimeEvent-${idInvolved}`);
        wrapperTimeBtn = sel.siblings(`.wrapper-btn-time-${idInvolved}`);
        if (status === 'on') { //SETTING ALL DAY TO EVERYTHING
          time = '00:00';
          inputTimeIn.val(time);
          inputTimeOut.val(time);
          spanTimeEvent.text('All Day');
          // SET DATA-TIMES IN LI FOR SAVING
          li.attr("data-timeIN", time);
          li.attr("data-timeOUT", time);
          //HIDE TIMEIN / TIMEOUT
          return wrapperTimeBtn.hide();
        } else {
          if (this.$el.find('#id-slider-allDay').val() === "off") {
            timeIn = this.$el.find('#id-input-booking-timeIn').val();
            timeOut = this.$el.find('#id-input-booking-timeOut').val();
          } else {
            timeIn = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStartTime'));
            timeOut = this.tm.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), this.usr.get('defaultEventStopTime'));
          }
          inputTimeIn.val(timeIn);
          inputTimeOut.val(timeOut);
          spanTimeEvent.html(`<span>${timeIn}</span> / <span>${timeOut}</span>`);
          btnTimeIn.text("Time In: " + timeIn);
          btnTimeOut.text("Time Out: " + timeOut);
          // SET DATA-TIMES IN LI FOR SAVING
          li.attr("data-timeIN", timeIn);
          li.attr("data-timeOUT", timeOut);
          //HIDE TIMEIN / TIMEOUT
          return wrapperTimeBtn.show();
        }
      }

      inputTimeInvolvedChanged(event) {
        /* GETTING DOM ELEMENTS TAKING CARE OF WHICH LI IS BEEN MODIFIED, DUPLICATED INVOVLED AWARENESS NOT USING OBJECT ID */
        var btnTarget, btnTimeIn, btnTimeOut, formatStr, formatTime, idInvolved, input, inputTimeIn, inputTimeOut, li, newTo, spanTimeEvent, ti, timeStr, to, type;
        input = $(event.currentTarget);
        idInvolved = input.attr('data-id');
        type = input.attr('data-type');
        li = input.closest('li');
        spanTimeEvent = li.find(`#id-spanTimeEvent-${idInvolved}`);
        if (type === 'TI') {
          inputTimeIn = input;
          inputTimeOut = input.siblings(`#input-involved-timeOUT-${idInvolved}`);
        } else {
          inputTimeIn = input.siblings(`#input-involved-timeIN-${idInvolved}`);
          inputTimeOut = input;
        }
        btnTimeIn = input.siblings().find(`#id-btn-timeIN-${idInvolved}`);
        btnTimeOut = input.siblings().find(`#id-btn-timeOUT-${idInvolved}`);
        formatTime = 'h:mm A';
        if (parseInt(this.usr.get('usesAMPM'), 10) === 0) {
          formatTime = 'h:mm';
        }
        switch (type) {
          case 'TI':
            timeStr = 'Time In: ' + input.val();
            btnTarget = btnTimeIn;
            formatStr = 'H:mm';
            if (_.indexOf(input.val(), 'M') !== -1) { //AMPM CHECK
              formatStr = 'h:mm A';
            }
            ti = Moment(input.val(), formatStr);
            to = Moment(inputTimeOut.val(), formatStr);
            if (ti > to) {
              ti.add('m', 15);
              newTo = ti.format(formatStr);
              inputTimeOut.val(newTo); //SET TIME OUT INPUT
              btnTimeOut.text('Time Out: ' + newTo); //SET TIME OUT BUTTON
            }
            break;
          case 'TO':
            timeStr = 'Time Out: ' + input.val();
            btnTarget = btnTimeOut;
        }
        //SET BUTTON TEXT
        btnTarget.text(timeStr);
        // SET TIME ON SPAN TIME EVENT
        spanTimeEvent.html(`<span>${inputTimeIn.val()}</span> / <span>${inputTimeOut.val()}</span>`);
        // SET DATA-TIMES IN LI FOR SAVING
        li.attr("data-timeIN", inputTimeIn.val());
        return li.attr("data-timeOUT", inputTimeOut.val());
      }

      btnDoneNoteInvolvedClicked(event) {
        var btn, li, text;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        text = btn.siblings('textarea').val();
        li = btn.closest('li');
        li.find('.edit-involved-note > .text').text(text);
        li.attr('data-involved-note', text);
        //HIDING WRAPER
        btn.parent().hide();
        return li.find('.edit-involved-note > .fwi-cross-cancel ').addClass('fwi-edit').removeClass('fwi-cross-cancel');
      }

      btnDeleteInvolvecClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return $(event.currentTarget).parents('li').remove();
      }

      //SAVING Booking
      btnSaveBookingClicked(event) {
        var booking, cur, dateIn, dateOut, diffDays, noteB, popUp, popUpHtml, ref;
        event.stopPropagation();
        event.preventDefault();
        booking = new Object();
        booking.sessionID = this.usr.get('sessionID');
        booking.parentType = 'project'; //HARDCODED TYPE OF BOOKING WTF!!!!
        //PROJECT ID IS THE PARENT ID
        booking.parentID = this.$el.find('#id-p-booking-project').attr('data-projectid');
        //CHECKING NUMBER OF INVOLVED
        if ($('.liBookingInvolved').length === 0) {
          popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>Error saving booking</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>Booking needs at least one involved<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a>
</div>
</div>`;
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          return;
        }
        //CHECKING IF PROJECT SELECTED
        if (!booking.parentID) {
          popUpHtml = `<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" data-dismissible="false" class="ui-corner-all">
<div data-role="header" data-theme="a" class="ui-corner-top">
<h3>Error saving booking</h3>
</div>
<div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">
<p>You need to select a Project<p>
<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a>
</div>
</div>`;
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          return;
        }
        booking.projectBinderID = !this.$el.find('#id-p-booking-binder').attr('data-binderid') ? "" : this.$el.find('#id-p-booking-binder').attr('data-binderid');
        if (this.$el.find('#id-p-booking-binder').attr('data-parentbinderid')) {
          booking.parentBinderID = this.$el.find('#id-p-booking-binder').attr('data-parentbinderid');
        }
        //DAY
        booking.day = this.dateSelected.format('YYYY-MM-DD'); //@$el.find('#id-input-booking-dayIn').val()
        if (this.$el.find('#id-slider-allDay').val() === 'on') {
          booking.timeIn = "0.000000";
          booking.timeOut = "24.000000";
        } else {
          //TIME IN  FLOAT
          booking.timeIn = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), this.$el.find('#id-input-booking-timeIn').val()).toFixed(6);
          //TIME OUT FLOAT
          booking.timeOut = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), this.$el.find('#id-input-booking-timeOut').val()).toFixed(6);
        }
        //OCUR DAYS
        dateIn = Moment(this.$el.find('#id-input-booking-dayIn').val(), 'DD-MM-YYYY');
        dateOut = Moment(this.$el.find('#id-input-booking-dayOut').val(), 'DD-MM-YYYY');
        diffDays = dateOut.diff(dateIn, 'days');
        if (diffDays > 0) {
          booking.occursOnDay = [];
          cur = dateIn;
          while (cur <= dateOut) {
            booking.occursOnDay.push(cur.format('YYYY-MM-DD'));
            cur.add('days', 1);
          }
        } else {
          booking.occursOnDay = dateIn.format('YYYY-MM-DD');
        }
        //ADHOC
        booking.isAdhoc = (ref = this.event.get('Booking')) != null ? ref.isAdhoc : void 0;
        //REQ NAME
        booking.name = window.html_entities(this.$el.find('#id-input-booking-name').val());
        booking.nameID = !this.$el.find('#id-input-booking-name').attr('data-nameID') ? "" : this.$el.find('#id-input-booking-name').attr('data-nameID');
        //REQ NOTE
        noteB = this.$el.find('#id-input-booking-note').val();
        if (noteB.length > 0) {
          booking.note = window.html_entities(noteB);
        }
        //NEW
        booking.bookingID = this.$el.find('#id-input-booking-name').attr('data-bookingID');
        //STATUS
        booking.status = this.$el.find('#id-p-booking-status').text();
        //created by
        booking.createdByID = this.event.get('Booking').createdByID;
        //STAGE
        booking.stageName = this.$el.find('.checkpoint-name').text();
        booking.stageValue = this.$el.find('.checkpoint-name').attr('data-stageValue');
        booking.Involved = new Array();
        _.each(this.$el.find('.liBookingInvolved'), (liInv) => {
          var invObj, ref1, ref2, timeIn, timeOut;
          if ($(liInv).find('.slider-involved-allday').val() === 'on') {
            timeIn = "0.000000";
            timeOut = "24.000000";
          } else {
            timeIn = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $(liInv).attr('data-timeIn')).toFixed(6);
            timeOut = this.tm.get_float_from_time_string(parseInt(this.usr.get('dayStartsAt'), 10), $(liInv).attr('data-timeOut')).toFixed(6);
          }
          invObj = {
            objectID: $(liInv).attr('data-objectID'),
            objectType: $(liInv).attr('data-objectType'),
            timeIn: timeIn,
            timeOut: timeOut,
            activityID: window.__check_undefined($(liInv).attr('data-activityID'))
          };
          if ($(liInv).attr('data-involved-note')) {
            invObj['note'] = window.html_entities($(liInv).attr('data-involved-note'));
          }
          if ((ref1 = $(liInv).attr('data-bookingLineID')) !== "bookingLineID" && ref1 !== "undefined") {
            invObj['bookingLineID'] = $(liInv).attr('data-bookingLineID');
          }
          if ((ref2 = $(liInv).attr('data-objectClassID')) !== "userObjectClassID" && ref2 !== "undefined") {
            invObj['objectClassID'] = $(liInv).attr('data-objectClassID');
          }
          return booking.Involved.push(invObj);
        });
        booking.CustomField = new Array();
        _.each(this.$el.find('.liBookingCustomField'), function(cf) {
          var cfObj, input, ref1, ref2, ref3, type, value;
          type = $(cf).attr('data-type');
          switch (type) {
            case 'checkbox':
              value = $(cf).find('.selector-checkbox-cfield').val();
              break;
            case 'entry':
              if (((ref1 = $(cf).find('.selector-company-cfield')) != null ? ref1.length : void 0) > 0) {
                value = $((ref2 = $(cf).find('span.selector-company-cfield')) != null ? ref2[0] : void 0).text();
              } else if (((ref3 = $(cf).find('.btn-contact-cfield')) != null ? ref3.length : void 0) > 0) {
                value = $(cf).find('.btn-contact-cfield').text();
              } else {
                value = $(cf).find('.entry-cfield').val();
              }
              break;
            case 'text':
              value = $(cf).find('.text-cfield').val();
              break;
            case 'selector':
              input = $(cf).find('.input-selector-cfield').val();
              if (input) {
                value = input;
              } else {
                value = $(cf).find('.radio-selector-cfield').val();
              }
              break;
            case 'date':
              value = $(cf).find('.input-date-cfield').val();
          }
          cfObj = {
            label: window.html_entities($(cf).attr('data-label')),
            value: window.html_entities(value),
            type: type
          };
          return booking.CustomField.push(cfObj);
        });
        event = new EventModel();
        event.on('change', this.__refresh_and_change_page, this);
        return event.save_booking(booking);
      }

      btnDeleteBookingClicked(event) {
        var request;
        event.preventDefault();
        event.stopPropagation();
        request = new Object();
        request.sessionID = this.usr.get('sessionID');
        request.bookingID = this.event.get('Booking').bookingID;
        request.bookingLineID = this.event.get('Booking').bookingLineID;
        request.day = this.dateSelected.format('YYYY-MM-DD');
        this.event.delete_event(request);
        return $.mobile.jqmNavigator.popToFirst({
          transition: 'none'
        });
      }

      __refresh_and_change_page(event) {
        var conflict, conflictHeaders, conflictMessage, conflictStr, found, i, index, isError, len, popUp, popUpHtml, popUpTitle, ref, ref1, view;
        if (event.get('EventCommitConflicts')) {
          conflict = event.get('EventCommitConflicts');
          isError = event.get('isError');
          if (isError === 1) {
            popUpTitle = "Error saving booking";
            conflictMessage = `<p>${conflict.header}</p>`;
          } else {
            popUpTitle = "Warning saving booking";
            conflictHeaders = [];
            if (_.isArray(conflict.Conflict)) {
              conflictHeaders = _.compact(_.map(conflict.Conflict, function(c) {
                return c != null ? c.header : void 0;
              }));
            } else if ((conflict.Conflict != null) && (conflict.Conflict.header != null)) {
              conflictHeaders = [conflict.Conflict.header];
            }
            if (conflictHeaders.length > 0) {
              conflictStr = conflictHeaders.join(', ');
            } else {
              conflictStr = 'Unknown conflict';
            }
            conflictMessage = `<p>${conflict.header}</p><p>Conflicts with: ${conflictStr}</p>`;
          }
          popUpHtml = '<div data-role="popup" id="popupAlert" data-overlay-theme="a" data-theme="c" class="ui-corner-all"> <div data-role="header" data-theme="a" class="ui-corner-top">';
          popUpHtml += `<h3>${popUpTitle}</h3>`;
          popUpHtml += '</div> <div data-role="content" data-theme="d" class="ui-corner-bottom ui-content">';
          popUpHtml += conflictMessage;
          popUpHtml += '<a href="#" data-role="button" data-inline="true" data-rel="back" data-theme="c" class="popUpDismiss">Dismiss</a> </div></div>';
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          if (isError !== 1) {
            $.mobile.loading('show');
            return setTimeout(() => {
              $.mobile.loading('hide');
              this.eventsCol.set_day_events(this.usr, event.get('day'));
              return $.mobile.jqmNavigator.popToFirst({
                transition: 'none'
              });
            }, 5000);
          }
        } else {
          if (!this.obj) {
            this.eventsCol.set_day_events(this.usr, event.get('day'));
            return $.mobile.jqmNavigator.popToFirst({
              transition: 'none'
            });
          } else {
            this.eventsCol.set_day_events(this.usr, event.get('day'), this.obj);
            index = 0;
            found = false;
            ref = $.mobile.jqmNavigator.getViews();
            for (i = 0, len = ref.length; i < len; i++) {
              view = ref[i];
              if ((ref1 = $(view.el).attr('id')) === 'id-EventListView' || ref1 === 'id-EventSheetView' || ref1 === 'id-EventDayPlan') {
                found = true;
                break;
              }
              index++;
            }
            if (!found) {
              index = 0;
            }
            return $.mobile.jqmNavigator.popToView(index, {
              transition: 'none'
            });
          }
        }
      }

      __set_involved_times(allDay, timeIn, timeOut) {
        _.each(this.$el.find('.liBookingInvolved'), function(li) {
          $(li).attr('data-timeIn', timeIn);
          return $(li).attr('data-timeOut', timeOut);
        });
        _.each(this.$el.find('.slider-involved-allday'), function(slider) {
          if (allDay) {
            $(slider).val("on");
            $(slider).siblings('.wrapper-btn-time').hide();
          } else {
            $(slider).val("off");
            $(slider).siblings('.wrapper-btn-time').show();
          }
          return $(slider).slider('refresh');
        });
        _.each(this.$el.find('.input-involved-timein'), function(ti) {
          return $(ti).val(timeIn);
        });
        _.each(this.$el.find('.input-involved-timeout'), function(to) {
          return $(to).val(timeOut);
        });
        _.each(this.$el.find('.btn-timeIN-involved'), function(ti) {
          if (allDay) {
            return $(ti).text('Time In');
          } else {
            return $(ti).text('Time In: ' + timeIn);
          }
        });
        _.each(this.$el.find('.btn-timeOUT-involved'), function(to) {
          if (allDay) {
            return $(to).text('Time Out');
          } else {
            return $(to).text('Time Out: ' + timeOut);
          }
        });
        return _.each(this.$el.find('.spanTimeEventInvolved'), function(span) {
          if (allDay) {
            return $(span).text("All Day");
          } else {
            return $(span).html(`<span>${timeIn}</span> / <span>${timeOut}</span>`);
          }
        });
      }

      __set_cfields_tab(bookingName) {
        var cfields, obj, ref;
        if (!bookingName) {
          obj = this.event.get('Booking');
        } else {
          obj = (ref = _.where(this.bookingList, {
            name: bookingName
          })) != null ? ref[0] : void 0;
        }
        if (obj != null ? obj.CustomField : void 0) {
          //BUTON ENABLED
          this.$el.find('#id-submenu-addbooking-cfields').removeClass('ui-disabled');
          //CUSTOM FIELDS PRINTING
          this.$el.find('#id-ul-addbooking-cfields').empty();
          cfields = obj.CustomField;
          if (!_.isArray(cfields)) {
            cfields = [obj.CustomField];
          }
          if (!CustomFieldView) {
            CustomFieldView = require("views/cfield/CustomFieldView");
          }
          _.each(cfields, (cf) => {
            var cfLi;
            cfLi = new CustomFieldView(this.usr, cf, 'form').render().el;
            //li = $('<li>').append(form)
            return this.$el.find('#id-ul-addbooking-cfields').append(cfLi);
          });
          /* UPDATING DOM STYLE */
          this.$el.find('#id-divAddBookingCFields').trigger('create');
        } else {
          this.$el.find('#id-submenu-addbooking-cfields').addClass('ui-disabled');
        }
        this.$el.find('#id-ul-addbooking-cfields').listview();
        return this.$el.find('#id-ul-addbooking-cfields').listview('refresh');
      }

      __set_involved_tab(bookingName) {
        var bookingTypeID, obj, predefobjs, ref;
        obj = (ref = _.where(this.bookingList, {
          name: bookingName
        })) != null ? ref[0] : void 0;
        predefobjs = null;
        bookingTypeID = obj != null ? obj.nameID : void 0;
        this.$el.find(".liBookingInvolved").filter('[data-bookingTypeID]:not([data-bookingTypeID=""])').remove();
        if (obj != null ? obj.PredefObject : void 0) {
          predefobjs = obj.PredefObject;
          if (!_.isArray(predefobjs)) {
            predefobjs = [obj.PredefObject];
          }
          return _.each(predefobjs, (po) => {
            var objectClassID, objectModel;
            objectModel = this.objectCol.findById(po.objectID);
            obj = new ObjectModel();
            if (objectModel.type === 'objectClass') {
              objectClassID = objectModel.objectID;
            } else {
              objectClassID = objectModel.objectClassID[0];
            }
            obj.set_object_detail(this.usr, objectModel.name, objectModel.objectID, objectModel.type, "BookingInvolved", objectClassID, bookingTypeID);
            if (objectModel != null) {
              return this.print_li_involved(obj);
            }
          });
        }
      }

      //HELPERS FOR REQUEST NAME FORM
      __go_to_request_form(bookingName) {
        if (bookingName !== 'status' && bookingName !== 'binder') {
          this.__set_cfields_tab(bookingName);
        }
        if (bookingName !== 'status' && bookingName !== 'binder') {
          this.__set_involved_tab(bookingName);
        }
        this.$el.find('#id-namerequest-form').hide();
        this.$el.find('.form-request-component').hide();
        this.$el.find('#id-booking-status-form').hide();
        this.$el.find('#id-projectbinder-form').hide();
        this.$el.find('#id-booking-checkpoint-form').hide();
        this.$el.find('#id-addrequest-form').show();
        //BUTTONS CONTROL
        this.$el.find('#id-btn-done-name').hide();
        //@$el.find('#id-btn-done-booking-status').hide()
        return this.$el.find('#id-btn-save-booking').show();
      }

      __go_to_name_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-namerequest-form').show();
        //BUTTONS CONTROL
        this.$el.find('#id-btn-done-name').show();
        return this.$el.find('#id-btn-save-booking').hide();
      }

      __go_to_status_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-booking-status-form').show();
        //BUTTONS CONTROL
        //@$el.find('#id-btn-done-booking-status').show()
        return this.$el.find('#id-btn-save-booking').hide();
      }

      __go_to_stage_form(params) {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-booking-checkpoint-form').show();
        //BUTTONS CONTROL
        //@$el.find('#id-btn-done-task-status').show()
        return this.$el.find('#id-btn-save-task').hide();
      }

      __go_to_projectbinder_form() {
        this.$el.find('#id-addrequest-form').hide();
        this.$el.find('#id-projectbinder-form').show();
        return this.$el.find('#id-btn-save-booking').hide();
      }

      __go_to_involved_activity_form(li) {
        var obj;
        if (!li) {
          return;
        }
        this.$el.find('#id-activity-involved-form').attr('data-li-pos', li.index());
        obj = new ObjectModel(this.usr);
        this.print_activity_list(this, obj.get_object_activity(li.attr('data-objectID')), false);
        this.$el.find('#id-btn-addInvolved').hide();
        this.$el.find('#id-ul-booking-involved').hide();
        this.$el.find('#id-activity-involved-form').show();
        this.$el.find('#id-activity-involved-form').trigger('create');
        return this.$el.find('#id-btn-save-booking').hide();
      }

      __go_to_involved_class_form(li) {
        var obj;
        if (!li) {
          return;
        }
        this.$el.find('#id-class-involved-form').attr('data-li-pos', li.index());
        obj = new ObjectModel(this.usr);
        this.print_class_list(this, obj.get_object_class(li.attr('data-objectID')), false);
        this.$el.find('#id-btn-addInvolved').hide();
        this.$el.find('#id-ul-booking-involved').hide();
        this.$el.find('#id-activity-involved-form').hide();
        this.$el.find('#id-class-involved-form').show();
        this.$el.find('#id-class-involved-form').trigger('create');
        return this.$el.find('#id-btn-save-booking').hide();
      }

      __go_to_involved_list() {
        this.$el.find('#id-btn-addInvolved').show();
        this.$el.find('#id-ul-booking-involved').show();
        this.$el.find('#id-activity-involved-form').hide();
        this.$el.find('#id-class-involved-form').hide();
        return this.$el.find('#id-btn-save-booking').show();
      }

      //TODO REFACTOR - UGLY DUPLICATED CODE IN CONTACT LIST (FORMPROJECT - CRUD BOOKING )
      addedProjectCfieldContact(view, contact) {
        var btn, obj;
        //liCfield = view.$el.find('.btn-contact-cfield[data-selected="true"]').closest('li').index()
        view.comingFromView = 'ContactSelector';
        $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
        btn = view.$el.find('.btn-contact-cfield[data-selected="true"]');
        if (btn.length === 0) {
          btn = view.$el.find('.btn-contact-cfield');
        }
        obj = contact.get('Contact');
        //SINCE PAGE SHOWN EVENT, LIST WAS REPRINTED
        //btn = view.$el.find('#id-ul-formproject-cfields li').eq(liCfield).find('.btn-contact-cfield')
        btn.find('.ui-btn-text').text(obj.firstName + ' ' + obj.lastName);
        btn.attr('data-contactID', obj.contactID);
        btn.attr('data-selected', false);
        return btn.button();
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnPopupClose(event) {
        return this.$el.find('#popupAlert').remove();
      }

    };
  });

}).call(this);
